/*= Instrument bp2318.h Include File =============================================*/
#include <vpptype.h>


#define NUL      0x00
#define STX      0x02
#define ETX      0x03
#define EOT      0x04
#define ENQ      0x05
#define ACK      0x06
#define CR       0x0D
#define NAK      0x15
#define MAX_BYTE 256            /* Max. Length of the local buffers*/

#define BP2318_MAX_INSTR  16    /* Max. numbers of instruments */

#define BP2318_OVERRANGE  (1<<9)/* Bit 9 of Questionable Condition Register*/
#define BP2318_MEASURING  (1<<4)/* Bit 4 of Operation Condition Register*/

/*= GLOBAL FUNCTION DECLARATIONS ==========================================*/
int _VI_FUNC bp2318_init (int COMPort, int baudRate, double timeoutseconds,
                          int blockCheck, int groupAddress, int userAddress,
                          int resetDevice, int *instrumentID);
int _VI_FUNC bp2318_set_config (int instrumentID, int resistanceLoad, int autoZero,
                                int range, int limit20mV, int tempComp);
int _VI_FUNC bp2318_get_config (int instrumentID, int *resistanceLoad,
                                int *autoZero, int *range, int *limit20mV,
                                int *tempComp);
int _VI_FUNC bp2318_meas_start (int instrumentID);
int _VI_FUNC bp2318_meas_read (int instrumentID, double *measuringValue,
                               char unit[]);
int _VI_FUNC bp2318_meas_stop (int instrumentID);
int _VI_FUNC bp2318_set_comp_limit (int instrumentID, int comparatorState,
                                    double lowerLimit, double upperLimit);
int _VI_FUNC bp2318_get_comp_limit (int instrumentID, int *comparatorState,
                                    double *lowerLimit, double *upperLimit);
int _VI_FUNC bp2318_set_address (int instrumentID, int groupAddress,
                                 int userAddress);
int _VI_FUNC bp2318_get_address (int instrumentID, int *groupAddress,
                                 int *userAddress);
int _VI_FUNC bp2318_system_error (int instrumentID, char systemError[]);
int _VI_FUNC bp2318_system_keyboard (int instrumentID, int keyboard);
int _VI_FUNC bp2318_reset (int instrumentID);
int _VI_FUNC bp2318_read_id (int instrumentID, char IDString[]);
int _VI_FUNC bp2318_display_test (int instrumentID);
int _VI_FUNC bp2318_send_scpi (int instrumentID, char sendSCPIMessage[]);
int _VI_FUNC bp2318_receive_scpi (int instrumentID, char sendSCPIMessage[],
                                  char instrumentAnswers[]);
int _VI_FUNC bp2318_close (int instrumentID);


/*int bp2318_init(int ,int ,double,int,int,int,int,int *);
int bp2318_close (int );

int bp2318_set_config(int ,int ,int, int,int,int);
int bp2318_get_config(int ,int* ,int* ,int*,int* ,int* );

int bp2318_meas_start(int );
int bp2318_meas_read(int ,double*,char*);
int bp2318_meas_stop(int );

int bp2318_set_comp_limit(int,int ,double ,double );
int bp2318_get_comp_limit(int,int* ,double* ,double* );

int bp2318_set_address(int ,int ,int);
int bp2318_get_address(int ,int* ,int *);
int bp2318_system_error(int,char* );
int bp2318_system_keyboard(int ,int);
int bp2318_reset(int );

int bp2318_read_id(int ,char*);
int bp2318_display_test(int);

int bp2318_send_scpi(int ,char*);
int bp2318_receive_scpi(int , char* ,char*);*/
